{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

{fetch_models assign=models section=$section.sectionId status='V' order="orderBy ASC" getImage=true imageType=['general', 'gallery', 'docs']}

<div class="header__sub">
	<div class="flex:col-max">
		<div class="header__sub-inner">
			{if !empty($section.gallery)}
				{assign var=logo value=$section.gallery|element:'position':'logo'}{if !empty($logo)}
					<div class="header__sub-logo"><img src="{$logo.original}" alt="{$logo.title}"></div>
				{/if}
			{/if}

			<div class="header__sub-nav">
				{if !empty($models)}
				<ul>
					{foreach item=model from=$models name=models}
						<li><a href="#{$model.fileName}">{$model.title}</a></li>
					{/foreach}
				</ul>
				{/if}
			</div>

			<div class="header__sub-select">
				<div class="header__sub-select-field"></div>

				<div class="header__sub-select-drop">
					<ul>
						{foreach item=model from=$models name=models}
							<li><a href="#{$model.fileName}">{$model.title}</a></li>
						{/foreach}
					</ul>
				</div>
			</div>
		</div>
	</div>
</div>

<main class="main">

	{* банер страницы *}
{*	{include file="modules/banner-page.tpl" size="meidum"}*}
	{* /банер страницы *}

	{if !empty($models)}
		{foreach item=model from=$models name=models}
			<section class="flex:col pad-tb-100" id="{$model.fileName}">
				<div class="flex:col-max">

					<div class="grid:fr-1">

						<div class="model-desc">

							<div class="model-desc__item">
								<div class="model-desc__slider common-slider">
									{if !empty($model.gallery)}
										<button class="arrow-slider simple common-prev_js">{include file="icon/svg.tpl" svgId="arrowLeft" fill="none"}</button>
										<div class="swiper model-desc-slider_js">
											<div class="swiper-wrapper">
												{foreach from=$model.gallery item=gallery}
													<div class="swiper-slide">
														<div class="model-desc__slider-item">
															<img src="{$gallery.original}" alt="">
														</div>
													</div>
												{/foreach}
											</div>
										</div>
										<button class="arrow-slider simple common-next_js">{include file="icon/svg.tpl" svgId="arrowRight" fill="none"}</button>
									{/if}
								</div>

								{* обратить внимание, разное изображение для декора *}
								<div class="model-desc__slider-decor">
									<img src="{$ASSETS_URL}/images/decor/1.jpg" alt="">
								</div>
							</div>

							<div class="model-desc__item">
								<div class="model-desc__item-head">
									<div class="text-tmp title-46">
										<h2>{$section.name} {$model.title}</h2>
									</div>

									<div class="model-desc__item-price">
										<ul>
											{if !empty($model.minOldPrice) && $model.minOldPrice > 0}<li class="old-price">от {$model.minOldPrice|number_format:0:",":" "} сум</li>{/if}
											{if !empty($model.minPrice) && $model.minPrice > 0}<li class="new-price">от {$model.minPrice|number_format:0:",":" "} сум</li>{/if}
										</ul>
									</div>

									{if !empty($model.minMonthPay) && $model.minMonthPay > 0}
										<div class="model-desc__item-credits-price">
											<ul>
												<li>Ежемесячный платеж:</li>
												<li>от {$model.minMonthPay|number_format:0:",":" "} сум</li>
											</ul>
										</div>
									{/if}
								</div>

								<div class="model-desc__item-content">
									<div class="text-tmp title-46 txt-color-accent-1">
										{$model.summary nofilter}
									</div>
									{if !empty($model.paymentMethods)}
										<div class="model-desc__item-credits">
											<ul>
												{foreach from=$model.paymentMethods item=paymentMethod}
													<li>{$paymentMethod}</li>
												{/foreach}
											</ul>
										</div>
									{/if}
								</div>

								<div class="model-desc__item-footer">
									<button class="btn accent-2" data-modal-id="modal_call" data-name="{$model.title}">Получить спецпредложение</button>
									{if !empty($model.docs)}
										{assign var=doc value=$model.docs|first}
										<a class="btn-arrow" href="{$GLOBAL_URL}{$doc.original}">Скачать прайс</a>
									{/if}
								</div>

							</div>

						</div>

					</div>

				</div>
			</section>
		{/foreach}
	{/if}

	{* Обратная связь *}
	{include file="blocks/feedback.tpl"}
	{* /Обратная связь *}

</main>

{include file="footer.tpl"}