{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}


{fetch_equipments_min_max assignMin=minPrice assignMax=maxPrice}

{if isset($smarty.get.brands) && !empty($smarty.get.brands)}
	{assign var=brands value=$smarty.get.brands}
	{assign var=queryBrands value=","|explode:$brands}

{else}
	{assign var=brands value=''}
{/if}

{if isset($smarty.get.min) && !empty($smarty.get.min)}
	{assign var=min value=$smarty.get.min}
{else}
	{assign var=min value=''}
{/if}
{if isset($smarty.get.max) && !empty($smarty.get.max)}
	{assign var=max value=$smarty.get.max}
{else}
	{assign var=max value=''}
{/if}

{fetch_model_equipments assign=equipments assignPagination=pagination brands=$brands minPrice=$min maxPrice=$max query=$query perPage=12 page=$page path=$section.path seFriendly=true}

<main class="main">

	<div class="flex:col pad-t-50">
		<div class="flex:col-max">
			{* bradcrumbs *}
			{include file="modules/breadcrumb.tpl" class="bradcrumbs" boldLastItem=false noLastLink=true}
			{* /bradcrumbs *}
		</div>
	</div>

	<section class="flex:col pad-t-50 pad-b-100">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-40">

				<div class="text-tmp title-46 all-center">
					<h2>{$section.name}</h2>
				</div>

				<button class="btn accent-3 x-center btn-filter-call_js">
					<svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20" fill="none">
						<path d="M2.08252 4.20375H11.298C11.5858 5.53312 12.7697 6.5325 14.1839 6.5325C15.5981 6.5325 16.782 5.53312 17.0699 4.20375H18.9178C19.263 4.20375 19.5428 3.92391 19.5428 3.57875C19.5428 3.23359 19.263 2.95375 18.9178 2.95375H17.0699C16.782 1.62437 15.5981 0.625 14.1839 0.625C12.7697 0.625 11.5858 1.62437 11.298 2.95375H2.08252C1.73736 2.95375 1.45752 3.23359 1.45752 3.57875C1.45752 3.92391 1.73736 4.20375 2.08252 4.20375ZM14.1839 1.875C15.1235 1.875 15.8877 2.63937 15.8877 3.57875C15.8877 4.51812 15.1233 5.2825 14.1839 5.2825C13.2445 5.2825 12.4802 4.51812 12.4802 3.57875C12.4802 2.63937 13.2444 1.875 14.1839 1.875Z" />
						<path d="M18.9178 9.37501H9.70236C9.41455 8.04564 8.23064 7.04626 6.81643 7.04626C5.40221 7.04626 4.2183 8.04564 3.93049 9.37501H2.08252C1.73736 9.37501 1.45752 9.65486 1.45752 10C1.45752 10.3452 1.73736 10.625 2.08252 10.625H3.93049C4.2183 11.9544 5.40221 12.9538 6.81643 12.9538C8.23064 12.9538 9.41455 11.9544 9.70236 10.625H18.9178C19.263 10.625 19.5428 10.3452 19.5428 10C19.5428 9.65486 19.263 9.37501 18.9178 9.37501ZM6.81643 11.7038C5.87689 11.7038 5.11268 10.9394 5.11268 10C5.11268 9.06064 5.87705 8.29626 6.81643 8.29626C7.7558 8.29626 8.52017 9.06048 8.52017 10C8.52017 10.9395 7.75596 11.7038 6.81643 11.7038Z" />
						<path d="M18.9178 15.7962H17.0699C16.782 14.4669 15.5981 13.4675 14.1839 13.4675C12.7697 13.4675 11.5858 14.4669 11.298 15.7962H2.08252C1.73736 15.7962 1.45752 16.0761 1.45752 16.4212C1.45752 16.7664 1.73736 17.0462 2.08252 17.0462H11.298C11.5858 18.3756 12.7697 19.375 14.1839 19.375C15.5981 19.375 16.782 18.3756 17.0699 17.0462H18.9178C19.263 17.0462 19.5428 16.7664 19.5428 16.4212C19.5428 16.0761 19.263 15.7962 18.9178 15.7962ZM14.1839 18.125C13.2444 18.125 12.4802 17.3606 12.4802 16.4212C12.4802 15.4819 13.2445 14.7175 14.1839 14.7175C15.1233 14.7175 15.8877 15.4819 15.8877 16.4212C15.8877 17.3606 15.1235 18.125 14.1839 18.125Z" />
					</svg>
					Фильтры
				</button>

				<div class="catalog">

					<aside class="catalog__aside filter_js">

						<button class="catalog__aside-close filter-close_js">
							<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#000">
								<path d="M256-227.69 227.69-256l224-224-224-224L256-732.31l224 224 224-224L732.31-704l-224 224 224 224L704-227.69l-224-224-224 224Z" />
							</svg>
						</button>

						{* пример: https://adm-aster.uz/cars-in-stock/?brands=changan,kia&min=377202000&max=1349900000 *}
						{* Бренды *}
						<div class="grid:fr-1 g-gap-20">
							<div class="text-tmp title-20 title-fw-500"><h3>Бренды</h3></div>
							<div class="grid:fr-1 g-gap-10">
								{fetch_sections assign=brands from=4 status="V"}{if $brands}
									{foreach from=$brands item=brand}
									<div class="checkbox theme-accent-2 checkbox-catalog_js">
										<label class="checkbox__label">
											<input class="checkbox__input brand_filter" type="checkbox" name="brands" value="{$brand.fileName}" {if !empty($queryBrands) && in_array($brand.fileName, $queryBrands)}checked{/if}>
											<span class="checkbox__content">
												<svg width="17" height="13" viewBox="0 0 17 13" fill="none" xmlns="http://www.w3.org/2000/svg">
													<path d="M15.0806 0L5.75806 9.20833L1.91935 5.41667L0 7.3125L5.75806 13L17 1.89583L15.0806 0Z" fill="white" />
												</svg>
											</span>

											<p>{$brand.name}</p>
										</label>
									</div>
									{/foreach}
								{/if}
							</div>
						</div>
						{* /Бренды *}

						{* Цена *}
						<div class="grid:fr-1 g-gap-20">
							<div class="text-tmp title-20 title-fw-500"><h3>Цена</h3></div>
							<div class="catalog__price">
								<div class="catalog__price-slider catalog-price_js" data-min="{$minPrice|number_format:0:",":""}" data-max="{$maxPrice|number_format:0:",":""}" data-current-min="{$min|default:0}" data-current-max="{$max|default:0}"></div>
							</div>

							<div class="catalog__price-fileds">
								<p class="catalog__price-filed"><span class="catalog-price-first_js"></span> сум</p>
								<p class="catalog__price-filed"><span class="catalog-price-second_js"></span> сум</p>
							</div>
						</div>
						{* Цена *}

						<a class="catalog__aside-btn-clear" href="{$SITE_URL}{$section.url}">Очистить фильтр</a>
						<button id="applyFilters" class="btn accent-2 full">Применить</button>

					</aside>

					<div class="catalog__content">
						<div class="catalog__content-inner">
							{foreach from=$equipments item=equipment}
								{* equipment item *}
								{include file="items/equipment.tpl"}
								{* /equipment item *}
							{/foreach}
						</div>

						{* pagination *}
						{include file="modules/pagination.tpl" class="pagination"}
						{* /pagination *}
					</div>
				</div>
			</div>
		</div>
	</section>

</main>


{include file="footer.tpl"}